select
	dcl.prodID,
	dcl.contentGuid,
	dc.url,
	dcmv.metaValueName as Resolution,
	dcmv2.metaValueName as Weight
from cds_Catalog as p
join cds_digContent_links dcl
	on dcl.prodID = p.prodID
join cds_digContent dc
	on dc.contentGuid = dcl.contentGuid
-- resolution
join cds_digContent_meta dcm
	on dcm.contentGuid = dc.contentGuid and dcm.metaAtrId = 6
join cds_digContent_meta_valVoc dcmv
	on dcmv.metaValueId = dcm.metaValueId
-- weight
join cds_digContent_meta dcm2
	on dcm2.contentGuid = dc.contentGuid and dcm2.metaAtrId = 7
join cds_digContent_meta_valVoc dcmv2
	on dcmv2.metaValueId = dcm2.metaValueId
join
(
	select
		dcl.prodID,
		max(dcmv.metaValueName) as weight 
	from cds_Catalog as p
	join cds_digContent_links dcl
		on dcl.prodID = p.prodID
	join cds_digContent dc
		on dc.contentGuid = dcl.contentGuid
	-- weight
	join cds_digContent_meta dcm
		on dcm.contentGuid = dc.contentGuid and dcm.metaAtrId = 7
	join cds_digContent_meta_valVoc dcmv
		on dcmv.metaValueId = dcm.metaValueId
	where dc.mediaTypeId = 15
	group by dcl.prodId
) as max_weight
	on max_weight.weight = dcmv2.metaValueName and max_weight.prodID = p.prodID
where
	dc.mediaTypeId = 15
order by prodID, resolution